#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgMaintainDivision;

#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_DivisionAlerts : BaseTest 
	{
		private BOL.DivisionAlerts _tstDA;
		private DataTable _dtDivision;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtDivision = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VamcDivision WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

			this._tstDA = new BOL.DivisionAlerts(this._dtDivision.Rows[0]);
			this._tstDA.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Alerts);
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{		
			BOL.DivisionAlerts tmpDA = new BOL.DivisionAlerts(this._dtDivision.Rows[0]);
			
			Assert.IsNotNull(tmpDA);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{	
		}


		[Test]
		public void PrintAlertsIndicator_Pass()
		{
			bool tstValue = (!this._tstDA.PrintAlertsIndicator);

			this._tstDA.PrintAlertsIndicator = tstValue;

			Assert.AreEqual(this._tstDA.PrintAlertsIndicator, tstValue);
		}

		[Test]
		public void PrintAlertsIndicator_Fail()
		{
			this._tstDA.PrinterName = String.Empty;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Unknown;

			this._tstDA.PrintAlertsIndicator = true;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrinterName));
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrintOrderAlertType));
		}
		
		[Test]
		public void PrinterName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstDA.PrinterName = tstValue;

			Assert.AreEqual(this._tstDA.PrinterName , tstValue);
		}

		[Test]
		public void PrinterName_Fail()
		{
			this._tstDA.PrintAlertsIndicator = true;

			this._tstDA.PrinterName = string.Empty;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrinterName));
		}

		[Test]
		public void PrintOrderAlertType_Pass()
		{
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Specimen_OK_or_NA;

			Assert.AreEqual(this._tstDA.PrintOrderAlertType, Common.OrderAlertTypeCode.Specimen_OK_or_NA);
		}

		[Test]
		public void PrintOrderAlertType_Fail()
		{
			this._tstDA.PrintAlertsIndicator = true;

			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Unknown;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrintOrderAlertType));

			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			this._tstDA.PrintOrderNeededHours = 0;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrintOrderNeededHours));

		}

		[Test]
		public void PrintOrderNeededHours_Pass()
		{
			int tstValue = new Random().Next(1,9999);

			this._tstDA.PrintOrderNeededHours = tstValue;

			Assert.AreEqual(this._tstDA.PrintOrderNeededHours, tstValue);
		}

		[Test]
		public void PrintOrderNeededHours_Fail()
		{
			this._tstDA.PrintAlertsIndicator = true;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			
			this._tstDA.PrintOrderNeededHours = 0;

			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.PrintOrderNeededHours));
		}

		
		[Test]
		public void IconAlertsIndicator_Pass()
		{
			bool tstValue = (!this._tstDA.IconAlertsIndicator);

			this._tstDA.IconAlertsIndicator = tstValue;

			Assert.AreEqual(this._tstDA.IconAlertsIndicator, tstValue);
		}

		[Test]
		public void IconAlertsIndicator_Fail()
		{
			this._tstDA.IconRefreshRate = 0;
			this._tstDA.IconAlertsIndicator = true;

			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconRefreshRate));

			this._tstDA.IconOrderAlertType = Common.OrderAlertTypeCode.Unknown;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconOrderAlertType));
		}
		
		[Test]
		public void IconRefreshRate_Pass()
		{
			int tstValue = new Random().Next(1,9999);

			this._tstDA.IconRefreshRate = tstValue;

			Assert.AreEqual(this._tstDA.IconRefreshRate, tstValue);
		}

		[Test]
		public void IconRefreshRate_Fail()
		{
			this._tstDA.IconAlertsIndicator = true;
			
			this._tstDA.IconRefreshRate = 0;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconRefreshRate));
		}

		[Test]
		public void IconOrderAlertType_Pass()
		{
			this._tstDA.IconOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			
			Assert.AreEqual(this._tstDA.IconOrderAlertType, Common.OrderAlertTypeCode.Hour_limit);
		}

		[Test]
		public void IconOrderAlertType_Fail()
		{
			this._tstDA.IconAlertsIndicator = true;

			this._tstDA.IconOrderAlertType = Common.OrderAlertTypeCode.Unknown;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconOrderAlertType));

			this._tstDA.IconOrdersNeededHours = 0;
			this._tstDA.IconOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconOrdersNeededHours));
		}

		[Test]
		public void IconOrdersNeededHours_Pass()
		{
			int tstValue = new Random().Next(1,9999);

			this._tstDA.IconOrdersNeededHours = tstValue;

			Assert.AreEqual(this._tstDA.IconOrdersNeededHours, tstValue);
		}

		[Test]
		public void IconOrdersNeededHours_Fail()
		{
			this._tstDA.IconAlertsIndicator = true;
			this._tstDA.IconOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			this._tstDA.IconOrdersNeededHours = 0;

			Assert.IsTrue(this._tstDA.IsRuleBroken(BROKEN.IconOrdersNeededHours));
		}


		[Test]
		public void LoginMessage_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstDA.LoginMessage = tstValue;

			Assert.AreEqual(this._tstDA.LoginMessage, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoginMessage_Fail()
		{
		}

		
		[Test]
		public void GetOrderAlertTypeList_Pass()
		{
			DataTable dtTest = BOL.DivisionAlerts.GetOrderAlertTypeList();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderAlertTypeList_Fail()
		{
		}


		[Test]
		public void GetPrinters_Pass()
		{			
			System.Collections.ArrayList alTest = BOL.DivisionAlerts.GetPrinters();

			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPrinters_Fail()
		{			
		}

		[Test]
		public void IsPatientOrderPrintAlertRequired_AllOrders_Pass()
		{
			DataTable dtOrder = BOL.PatientOrder.InitializePatientOrderTable();
			DataTable dtTests = BOL.OrderedTest.GetEmptyOrderedTestTableSchema(true);
			DataTable dtComponents = BOL.OrderedComponent.InitializeOrderedComponentTable();
			//
			this._tstDA.PrintAlertsIndicator = true;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.All_orders;
			//
			Assert.IsTrue(this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,dtComponents,dtTests,UnitTestConfig.TestDivisionCode),"All");
		}

		[Test]
		public void IsPatientOrderPrintAlertRequired_SpecimenOKorNA_Pass()
		{
			DataTable dtOrder = BOL.PatientOrder.InitializePatientOrderTable();
			DataTable dtTests = BOL.OrderedTest.GetEmptyOrderedTestTableSchema(true);
			DataTable dtComponents = BOL.OrderedComponent.InitializeOrderedComponentTable();
			//
			this._tstDA.PrintAlertsIndicator = true;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Specimen_OK_or_NA;
			DataRow drComponent = dtComponents.NewRow();
			drComponent[TABLES.SpecimenStatus.SpecimenStatusCode] = Common.SpecimenStatus.Required.ToString();
			drComponent[TABLES.OrderedComponent.PatientSpecimenGuid] = Guid.NewGuid();
			dtComponents.Rows.Add(drComponent);
			//
			Assert.IsTrue(this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,dtComponents,new DataTable(),UnitTestConfig.TestDivisionCode),"SpecimenComponent");
			//
			DataRow drTest = dtTests.NewRow();
			drTest[TABLES.OrderedTest.PatientSpecimenGuid] = Guid.NewGuid();
			dtTests.Rows.Add(drTest);
			//
			Assert.IsTrue(this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,new DataTable(),dtTests,UnitTestConfig.TestDivisionCode),"SpecimenTest");
		}

		[Test]
		public void IsPatientOrderPrintAlertRequired_HourLimit_Pass()
		{
			DataTable dtOrder = BOL.PatientOrder.InitializePatientOrderTable();
			DataTable dtTests = BOL.OrderedTest.GetEmptyOrderedTestTableSchema(true);
			DataTable dtComponents = BOL.OrderedComponent.InitializeOrderedComponentTable();
			//
			this._tstDA.PrintAlertsIndicator = true;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Hour_limit;
			DataRow drComponent = dtComponents.NewRow();
			drComponent[TABLES.OrderedComponent.RequiredDatetime] = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode);
			dtComponents.Rows.Add(drComponent);
			//
			Assert.IsTrue(this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,dtComponents,new DataTable(),UnitTestConfig.TestDivisionCode),"HourComponent");
			//
			DataRow drTest = dtTests.NewRow();
			drTest[TABLES.OrderedTest.RequiredResultsDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode);
			dtTests.Rows.Add(drTest);
			//
			Assert.IsTrue(this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,new DataTable(),dtTests,UnitTestConfig.TestDivisionCode),"HourTest");
		}

		[Test]
		public void IsPatientOrderPrintAlertRequired_Fail()
		{
			DataTable dtOrder = BOL.PatientOrder.InitializePatientOrderTable();
			DataTable dtTests = BOL.OrderedTest.GetEmptyOrderedTestTableSchema(true);
			DataTable dtComponents = BOL.OrderedComponent.InitializeOrderedComponentTable();
			//
			this._tstDA.PrintAlertsIndicator = true;
			this._tstDA.PrintOrderAlertType = Common.OrderAlertTypeCode.Unknown;
			//
			Assert.IsTrue(!this._tstDA.IsPatientOrderPrintAlertRequired(dtOrder,dtComponents,dtTests,UnitTestConfig.TestDivisionCode));
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'" );
			//
			// DivisionAlerts.LoadDataRowFromThis has not been implemented 
			Assert.IsTrue( this._tstDA.LoadDataRowFromThis( dr ).Equals( dr ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}
	}
}

#endif
